-- First run init.sql to create the database and tables
-- Then run this script to seed the database with random data 
-- (preferably in pgadmin or similar)

-- Parameters
DO $$
DECLARE
    start_time TIMESTAMPTZ := now() - INTERVAL '10 minutes';
    interval_ms INTERVAL := INTERVAL '500 milliseconds';
    sensor TEXT := 'sensor_1';
    temp DOUBLE PRECISION;
    i INT := 0;
BEGIN
    WHILE i < 1200 LOOP
        temp := 20 + random() * 5;  -- Simulated temp between 20 and 25°C
        INSERT INTO temperature_sensor_data (time, sensor_id, temperature)
        VALUES (start_time + i * interval_ms, sensor, temp);
        i := i + 1;
    END LOOP;
END $$;









